/// Remove null values from a map. This helps with JSON conversion and validation.
///
/// @param mapToEdit a {@link Map} from which to remove the keys that have {@code null} values

void removeNullAndEmptyParams(Map<dynamic, dynamic> mapToEdit) {
// Remove all null values; they cause validation errors
  final keys = mapToEdit.keys.toList(growable: false);
  for (String key in keys) {
    final value = mapToEdit[key];
    if (value == null) {
      mapToEdit.remove(key);
    } else if (value is String) {
      if (value.isEmpty) {
        mapToEdit.remove(key);
      }
    } else if (value is Map) {
      removeNullAndEmptyParams(value);
    }
  }
}
